/*
 * Decompiled with CFR 0.152.
 */
package unmap;

public class Vec {
    float x;
    float y;
    float z;

    public Vec() {
        this(0.0f, 0.0f, 0.0f);
    }

    public Vec(Vec v) {
        this(v.x, v.y, v.z);
    }

    public Vec(float ox, float oy, float oz) {
        this.x = ox;
        this.y = oy;
        this.z = oz;
    }

    public float dot(Vec that) {
        return this.x * that.x + this.y * that.y + this.z * that.z;
    }

    public Vec cross(Vec that) {
        Vec ret = new Vec();
        ret.x = this.y * that.z - this.z * that.y;
        ret.y = this.z * that.x - this.x * that.z;
        ret.z = this.x * that.y - this.y * that.x;
        return ret;
    }

    public Vec norm() {
        Vec ret = new Vec();
        float len = this.modulus();
        ret.x = this.x / len;
        ret.y = this.y / len;
        ret.z = this.z / len;
        return ret;
    }

    public Vec add(Vec that) {
        Vec ret = new Vec();
        ret.x = this.x + that.x;
        ret.y = this.y + that.y;
        ret.z = this.z + that.z;
        return ret;
    }

    public Vec subtract(Vec that) {
        Vec ret = new Vec();
        ret.x = this.x - that.x;
        ret.y = this.y - that.y;
        ret.z = this.z - that.z;
        return ret;
    }

    public void snap(float value) {
        this.x = (float)Math.round(this.x / value) * value;
        this.y = (float)Math.round(this.y / value) * value;
        this.z = (float)Math.round(this.z / value) * value;
    }

    public boolean notvalid() {
        return Float.isNaN(this.x) || Float.isNaN(this.y) || Float.isNaN(this.z);
    }

    public float modulus() {
        return (float)Math.sqrt(Math.pow(this.x, 2.0) + Math.pow(this.y, 2.0) + Math.pow(this.z, 2.0));
    }

    public Vec scalar(float mul) {
        Vec ret = new Vec();
        ret.x = this.x * mul;
        ret.y = this.y * mul;
        ret.z = this.z * mul;
        return ret;
    }

    public float comp(int axis) {
        switch (axis) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        return 0.0f;
    }

    public void setcomp(int axis, float value) {
        switch (axis) {
            case 0: {
                this.x = value;
                break;
            }
            case 1: {
                this.y = value;
                break;
            }
            case 2: {
                this.z = value;
            }
        }
    }

    public Vec addmult(float scale, Vec that) {
        Vec ret = new Vec();
        ret.x = this.x + scale * that.x;
        ret.y = this.y + scale * that.y;
        ret.z = this.z + scale * that.z;
        return ret;
    }

    public Vec minbound(Vec mins) {
        Vec ret = new Vec(mins);
        if (this.x < mins.x) {
            ret.x = this.x;
        }
        if (this.y < mins.y) {
            ret.y = this.y;
        }
        if (this.z < mins.z) {
            ret.z = this.z;
        }
        return ret;
    }

    public Vec maxbound(Vec maxs) {
        Vec ret = new Vec(maxs);
        if (this.x > maxs.x) {
            ret.x = this.x;
        }
        if (this.y > maxs.y) {
            ret.y = this.y;
        }
        if (this.z > maxs.z) {
            ret.z = this.z;
        }
        return ret;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public Vec copy() {
        Vec ret = new Vec();
        ret.x = this.x;
        ret.y = this.y;
        ret.z = this.z;
        return ret;
    }
}

